/*
 * Decompiled with CFR 0.152.
 */
package pl.hiplay.lorak.lkaacmanager.bypasses;

import de.photon.AACAdditionPro.events.HeuristicsAdditionViolationEvent;
import java.util.Arrays;
import java.util.List;
import me.konsolas.aac.api.HackType;
import me.konsolas.aac.api.PlayerViolationEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import pl.hiplay.lorak.lkaacmanager.bypasses.Bypass;
import pl.hiplay.lorak.lkaacmanager.data.PlayerBypassInfo;

public class ComboBypass
extends Bypass {
    private static final HackType[] moveChecks = new HackType[]{HackType.SPEED, HackType.FLY};
    private static final List<HackType> checksBypassed = Arrays.asList(HackType.KILLAURA, HackType.HITBOX, HackType.INTERACT);
    private int moveBypassTicks;
    private int heuristicsBypassTicks;

    public ComboBypass() {
        this.setName("ComboBypass");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void damageHandler(EntityDamageByEntityEvent e) {
        if (e.getEntity() instanceof Player && e.getDamager() instanceof Player) {
            Player victim = (Player)e.getEntity();
            Player damager = (Player)e.getDamager();
            PlayerBypassInfo victimInfo = this.plugin.getBypassManager().getInfo(victim);
            if (this.isCombo(victim)) {
                victimInfo.addBypass((Enum[])moveChecks, this.moveBypassTicks);
            }
            PlayerBypassInfo damagerInfo = this.plugin.getBypassManager().getInfo(damager);
            if (!this.isCombo(damager) && damagerInfo.isLastHitCombo()) {
                damagerInfo.addBypass((Enum)HackType.HEURISTICS, this.heuristicsBypassTicks);
            }
            damagerInfo.setLastHit(this.isCombo(damager));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void handleAAC(PlayerViolationEvent e) {
        PlayerBypassInfo info = this.plugin.getBypassManager().getInfo(e.getPlayer());
        if (!info.isLastHitCombo()) {
            return;
        }
        if (checksBypassed.contains(e.getHackType())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void handleHeuristics(HeuristicsAdditionViolationEvent e) {
        PlayerBypassInfo info = this.plugin.getBypassManager().getInfo(e.getPlayer());
        if (info == null) {
            return;
        }
        if (info.isLastHitCombo()) {
            e.setCancelled(true);
        }
    }

    private boolean isCombo(Player p) {
        return p.getMaximumNoDamageTicks() <= 10;
    }

    @Override
    public void loadConfig() {
        this.moveBypassTicks = this.plugin.getConfig().getInt(this.getName() + ".moveBypassTicks");
        this.heuristicsBypassTicks = this.plugin.getConfig().getInt(this.getName() + ".heuristicsBypassTicks");
    }
}

