/*
 * Decompiled with CFR 0.152.
 */
package pl.hiplay.lorak.lkaacmanager.modules;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import me.konsolas.aac.api.AACAPILoadedEvent;
import me.konsolas.aac.api.AACAPIProvider;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import pl.hiplay.lorak.lkaacmanager.Util;
import pl.hiplay.lorak.lkaacmanager.lkAACManager;

public class AACHider
implements Listener {
    private static AACHider instance;
    private static lkAACManager plugin;
    private String aacPerm;
    private String aacClass;
    private String aacPermMsg;
    private PacketListener aacListener;

    private AACHider() {
    }

    public static void init() {
        instance = new AACHider();
        plugin = (lkAACManager)Bukkit.getPluginManager().getPlugin("lkaacmanager");
        instance.loadConfig();
        if (AACAPIProvider.isAPILoaded()) {
            instance.unregisterAAC();
        }
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Client.CHAT}){

            public void onPacketReceiving(PacketEvent event) {
                if (event.getPacketType() == PacketType.Play.Client.CHAT && ((String)event.getPacket().getStrings().read(0)).toLowerCase().startsWith("/aac")) {
                    if (event.getPlayer().hasPermission(AACHider.getInstance().aacPerm) && AACHider.getInstance().aacListener != null) {
                        AACHider.getInstance().aacListener.onPacketReceiving(event);
                    } else {
                        event.setCancelled(true);
                        Util.send((CommandSender)event.getPlayer(), AACHider.getInstance().aacPermMsg);
                    }
                }
            }
        });
        plugin.getServer().getPluginManager().registerEvents((Listener)instance, (Plugin)plugin);
    }

    public static AACHider getInstance() {
        return instance;
    }

    public void loadConfig() {
        this.aacPerm = plugin.getConfig().getString("AACHider.aacPerm");
        this.aacClass = plugin.getConfig().getString("AACHider.aacClass");
        this.aacPermMsg = plugin.getConfig().getString("AACHider.aacPermMsg");
    }

    @EventHandler
    public void AACAPIloaded(AACAPILoadedEvent e) {
        this.unregisterAAC();
    }

    private void unregisterAAC() {
        for (PacketListener p : ProtocolLibrary.getProtocolManager().getPacketListeners()) {
            if (p.getClass().getCanonicalName() == null || !p.getClass().getCanonicalName().startsWith(this.aacClass)) continue;
            plugin.getLogger().info("Unregistering " + p.getClass().getCanonicalName());
            this.aacListener = p;
            ProtocolLibrary.getProtocolManager().removePacketListener(this.aacListener);
        }
    }
}

