/*
 * Decompiled with CFR 0.152.
 */
package pl.hiplay.lorak.lkaacmanager.modules;

import de.photon.AACAdditionPro.ModuleType;
import de.photon.AACAdditionPro.events.PlayerAdditionViolationEvent;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.konsolas.aac.api.HackType;
import me.konsolas.aac.api.PlayerViolationEvent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import pl.hiplay.lorak.lkaacmanager.Util;
import pl.hiplay.lorak.lkaacmanager.data.PlayerBypassInfo;
import pl.hiplay.lorak.lkaacmanager.lkAACManager;

public final class BypassManager
implements Listener {
    private static BypassManager instance;
    private final lkAACManager plugin;
    private Map<UUID, PlayerBypassInfo> bypasses = new ConcurrentHashMap<UUID, PlayerBypassInfo>();

    private BypassManager() {
        this.plugin = (lkAACManager)Bukkit.getPluginManager().getPlugin("lkaacmanager");
        this.processOrdinals();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.addPlayer(player);
        }
    }

    public static void init() {
        if (instance == null) {
            instance = new BypassManager();
        }
    }

    public static BypassManager getInstance() {
        return instance;
    }

    public void sendStatus(CommandSender p) {
        Util.send(p, "&6BypassManager: ");
        Util.send(p, "&eTicks: &f" + Util.getTicks() + " &ePlayers: &f" + this.bypasses.size());
    }

    public PlayerBypassInfo getInfo(Player p) {
        if (p == null) {
            return null;
        }
        return this.bypasses.get(p.getUniqueId());
    }

    private void addPlayer(Player p) {
        if (p != null) {
            this.bypasses.put(p.getUniqueId(), new PlayerBypassInfo(p));
        } else {
            Util.addWarning("&c(BypassManager) Warning! Tried to insert null player!");
        }
    }

    private void removePlayer(Player p) {
        if (p != null) {
            this.bypasses.remove(p.getUniqueId());
        } else {
            Util.addWarning("&c(BypassManager) Warning! Tried to remove null player!");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onJoin(PlayerJoinEvent e) {
        this.addPlayer(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onQuit(PlayerQuitEvent e) {
        this.removePlayer(e.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void handleAAC(PlayerViolationEvent e) {
        if (e.getPlayer() != null && this.getInfo(e.getPlayer()).isBypassed((Enum)e.getHackType())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void handleAACAP(PlayerAdditionViolationEvent e) {
        if (e.getPlayer() != null && this.getInfo(e.getPlayer()).isBypassed((Enum)e.getModuleType())) {
            e.setCancelled(true);
        }
    }

    private void processOrdinals() {
        int i;
        for (i = 0; i < Arrays.asList(HackType.values()).size(); ++i) {
            if (i == HackType.values()[i].ordinal()) continue;
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            throw new RuntimeException("Invalid ordinal in AAC checks!");
        }
        for (i = 0; i < Arrays.asList(ModuleType.values()).size(); ++i) {
            if (i == ModuleType.values()[i].ordinal()) continue;
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            throw new RuntimeException("Invalid ordinal in AACAdditionPro checks!");
        }
        PlayerBypassInfo.sizeAAC = Arrays.asList(HackType.values()).size();
        PlayerBypassInfo.sizeAACAP = Arrays.asList(ModuleType.values()).size();
    }
}

