/*
 * Decompiled with CFR 0.152.
 */
package pl.hiplay.lorak.lkaacmanager.modules;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import pl.hiplay.lorak.lkaacmanager.Util;
import pl.hiplay.lorak.lkaacmanager.lkAACManager;

public class ConfigEditor {
    private static ConfigEditor instance;
    String config = "";
    lkAACManager plugin = (lkAACManager)Bukkit.getPluginManager().getPlugin("lkaacmanager");
    File AACFile;
    File AACAPFile;
    File ACMGFile;
    String AACLink;
    String AACAPLink;
    String ACMGLink;

    private ConfigEditor() {
        this.loadConfig();
        this.loadFiles(null);
    }

    public static void init() {
        if (instance == null) {
            instance = new ConfigEditor();
        }
    }

    public static ConfigEditor getInstance() {
        return instance;
    }

    public void loadConfig() {
        this.AACLink = this.plugin.getConfig().getString("ConfigEditor.aacLink");
        this.AACAPLink = this.plugin.getConfig().getString("ConfigEditor.aacapLink");
        this.ACMGLink = this.plugin.getConfig().getString("ConfigEditor.acmgLink");
    }

    public void sendStatus(CommandSender p) {
        Util.send(p, "&6Rozmiar configu (znaki): &a" + Integer.toString(this.config.length()));
        Util.send(p, "&6Suma kontrolna: &a" + this.getHash());
    }

    public void downloadConfig(String url, CommandSender p) {
        url = this.getLink(url, p) == null ? url : this.getLink(url, p);
        try {
            String inputLine;
            if (url == null) {
                Util.sendWarning(p, "&4(ConfigManager) URL == null!");
                return;
            }
            URL website = new URL(url);
            URLConnection connection = website.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine).append("\n");
            }
            in.close();
            this.config = response.toString();
            Util.sendInfo(p, "&6(ConfigManager) Pobrano config!");
            this.sendStatus(p);
        }
        catch (Exception e) {
            Util.sendWarning(p, "&4(ConfigManager) Blad podczas pobierania configu!");
            Util.sendWarning(p, "URL: " + url);
            Util.sendWarning(p, e.toString());
        }
    }

    public void loadFiles(CommandSender p) {
        this.AACFile = new File("plugins/AAC/config.yml");
        if (!this.AACFile.exists()) {
            this.AACFile = null;
        }
        this.AACAPFile = new File("plugins/AACAdditionPro/config.yml");
        if (!this.AACAPFile.exists()) {
            this.AACAPFile = null;
        }
        this.ACMGFile = new File("plugins/lkaacmanager/config.yml");
        if (!this.ACMGFile.exists()) {
            this.ACMGFile = null;
        }
        if (p != null) {
            Util.sendInfo(p, "&6(ConfigManager) Przeladowano pliki configow");
        }
    }

    public void printConfig(CommandSender p) {
        for (String s : this.config.split("\\R")) {
            p.sendMessage(s);
        }
    }

    public void readFile(String f, CommandSender p) {
        File readFrom = this.getFile(f, p);
        if (readFrom != null) {
            try {
                byte[] encoded = Files.readAllBytes(Paths.get(readFrom.getPath(), new String[0]));
                this.config = new String(encoded, Charset.defaultCharset());
                Util.sendInfo(p, "&6(ConfigManager) Odczytano plik");
            }
            catch (Exception e) {
                Util.sendWarning(p, "&c(ConfigManager) Nie udalo sie odczytac pliku");
            }
        } else {
            Util.sendWarning(p, "&c(ConfigManager) Plik do odczytu jest null'em");
        }
    }

    public void saveConfig(String f, CommandSender p) {
        File writeTo = this.getFile(f, p);
        if (writeTo != null) {
            try {
                FileWriter f2 = new FileWriter(writeTo, false);
                f2.write(this.config);
                f2.close();
                Util.sendInfo(p, "&6(ConfigManager) Zapisano plik");
            }
            catch (IOException e) {
                Util.sendWarning(p, "&c(ConfigManager) Nie udalo sie nadpisac pliku");
            }
        } else {
            Util.sendWarning(p, "&c(ConfigManager) Plik do zapisu jest null'em");
        }
    }

    private File getFile(String f, CommandSender p) {
        File x;
        if (f.equalsIgnoreCase("aac")) {
            x = this.AACFile;
        } else if (f.equalsIgnoreCase("aacap")) {
            x = this.AACAPFile;
        } else if (f.equalsIgnoreCase("acmg")) {
            x = this.ACMGFile;
        } else {
            x = null;
            Util.sendWarning(p, "&c(ConfigManager)Nieznany parametr: " + f);
        }
        return x;
    }

    private String getLink(String f, CommandSender p) {
        if (f.equalsIgnoreCase("aac")) {
            return this.AACLink;
        }
        if (f.equalsIgnoreCase("aacap")) {
            return this.AACAPLink;
        }
        if (f.equalsIgnoreCase("acmg")) {
            return this.ACMGLink;
        }
        return null;
    }

    private String getHash() {
        String data = this.config;
        StringBuffer sb = new StringBuffer();
        try {
            byte[] byteData;
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(data.getBytes());
            for (byte aByteData : byteData = md.digest()) {
                sb.append(Integer.toString((aByteData & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

