/*
 * Decompiled with CFR 0.152.
 */
package pl.hiplay.lorak.lkaacmanager.modules;

import de.photon.AACAdditionPro.ModuleType;
import de.photon.AACAdditionPro.events.HeuristicsAdditionViolationEvent;
import de.photon.AACAdditionPro.events.PlayerAdditionViolationCommandEvent;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import pl.hiplay.lorak.lkaacmanager.data.HeurEntry;
import pl.hiplay.lorak.lkaacmanager.data.PlayerBypassInfo;
import pl.hiplay.lorak.lkaacmanager.lkAACManager;

public class HeuristicsManager
implements Listener {
    private static HeuristicsManager instance;
    private static lkAACManager plugin;
    private int heurCooldown;

    private HeuristicsManager() {
    }

    public static void init() {
        instance = new HeuristicsManager();
        plugin = (lkAACManager)Bukkit.getPluginManager().getPlugin("lkaacmanager");
        instance.loadConfig();
        plugin.getServer().getPluginManager().registerEvents((Listener)instance, (Plugin)plugin);
    }

    public void loadConfig() {
        this.heurCooldown = plugin.getConfig().getInt("HeuristicsManager.heurCooldown");
    }

    public static HeuristicsManager getInstance() {
        return instance;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void heuristicsViolation(HeuristicsAdditionViolationEvent e) {
        PlayerBypassInfo info = plugin.getBypassManager().getInfo(e.getPlayer());
        if (info == null) {
            return;
        }
        info.heurViolation(e.getPattern(), e.getConfidence());
    }

    @EventHandler(ignoreCancelled=false)
    public void handleHeurCmd(PlayerAdditionViolationCommandEvent e) {
        if (e.getModuleType() == ModuleType.PER_HEURISTIC_COMMANDS) {
            PlayerBypassInfo info = plugin.getBypassManager().getInfo(e.getPlayer());
            if (info == null) {
                return;
            }
            e.setCommand(e.getCommand().replace("{{HEURISTICS}}", this.getHeurInfo(info)));
        }
    }

    public String getHeurInfo(PlayerBypassInfo info) {
        List arr = info.getHeuristicsInfo().values().stream().sorted(Comparator.reverseOrder()).map(HeurEntry::toColorizedString).collect(Collectors.toList());
        return String.join((CharSequence)" &7&l| ", arr);
    }
}

