/*
 * Decompiled with CFR 0.152.
 */
package pl.hiplay.lorak.lkaacmanager.modules;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import pl.hiplay.lorak.lkaacmanager.Util;
import pl.hiplay.lorak.lkaacmanager.lkAACManager;
import pl.hiplay.lorak.lkaacmanager.modules.ServerName;

public class Updater {
    private final Map<String, String> Filenames = new ConcurrentHashMap<String, String>();
    private static Updater instance;
    private lkAACManager plugin;

    private Updater() {
        this.Filenames.put("plugins/AAC/config.yml", "");
        this.Filenames.put("plugins/AACAdditionPro/config.yml", "");
        this.Filenames.put("plugins/lkaacmanager/config.yml", "");
        this.plugin = (lkAACManager)Bukkit.getPluginManager().getPlugin("lkaacmanager");
        this.loadFiles(null);
    }

    public static void init() {
        if (instance == null) {
            instance = new Updater();
        }
    }

    public static Updater getInstance() {
        return instance;
    }

    public void loadFiles(CommandSender invoker) {
        for (Map.Entry<String, String> f : this.Filenames.entrySet()) {
            String hash;
            byte[] data = this.readFile(f.getKey(), invoker);
            if (data == null || data.length == 0 || (hash = this.getHash(data, invoker)) == null || hash.equals("")) continue;
            this.Filenames.put(f.getKey(), hash);
        }
    }

    public void printFile(String file, CommandSender sender) {
        String path = this.Filenames.containsKey(file) ? file : null;
        if (path == null) {
            Util.sendWarning(sender, "Nie odnaleziono pliku!" + file);
            return;
        }
        File readFrom = new File(path);
        if (!readFrom.exists()) {
            Util.sendWarning(sender, "Plik nie istnieje" + file);
            return;
        }
        try {
            byte[] encoded = Files.readAllBytes(readFrom.toPath());
            String s = new String(encoded, Charset.defaultCharset());
            sender.sendMessage(s.split("\\r"));
        }
        catch (Exception e) {
            Util.send(sender, "Blad podczas przetwarzania pliku!");
            for (StackTraceElement element : e.getStackTrace()) {
                sender.sendMessage(element.toString());
            }
        }
    }

    public void update(CommandSender invoker) {
        YamlConfiguration updates = new YamlConfiguration();
        byte[] data = this.downloadURL(ServerName.getConfigLink(), invoker);
        if (data == null) {
            return;
        }
        try {
            updates.loadFromString(new String(data, Charset.forName("UTF-8")));
        }
        catch (InvalidConfigurationException e) {
            if (invoker == null) {
                Util.acnotify("&4Updater: error 2. Server: " + ServerName.getServerName());
            } else {
                Util.send(invoker, "&4Updater: error 2. Server: " + ServerName.getServerName());
            }
            return;
        }
        try {
            Set configs = updates.getConfigurationSection("configs." + ServerName.getConfigType()).getKeys(false);
            if (configs == null || configs.size() == 0) {
                if (invoker == null) {
                    Util.acnotify("&4Updater: error 3. Server: " + ServerName.getServerName());
                } else {
                    Util.send(invoker, "&4Updater: error 3. Server: " + ServerName.getServerName());
                }
                return;
            }
            for (String key : configs) {
                if (this.Filenames.get(key) == null) {
                    if (invoker == null) {
                        Util.acnotify("&4Updater: error 4. Server: " + ServerName.getServerName());
                        continue;
                    }
                    Util.send(invoker, "&4Updater: error 4. Server: " + ServerName.getServerName());
                    continue;
                }
                if (!this.Filenames.get(key).equals(updates.getString("configs." + ServerName.getConfigType() + "." + key + ".sum"))) {
                    String link = updates.getString("configs." + ServerName.getConfigType() + "." + key + ".link");
                    byte[] newcfg = this.downloadURL(link, invoker);
                    if (newcfg == null) continue;
                    String check_hash = this.getHash(newcfg, invoker);
                    if (!check_hash.equals(updates.getString("configs." + ServerName.getConfigType() + "." + key + ".sum"))) {
                        String error = "&4Blad pobierania? Bledna suma kontrolna pobranych danych" + key + " Server: " + ServerName.getServerName() + " Config: " + ServerName.getConfigType();
                        if (invoker == null) {
                            Util.acnotify(error);
                            continue;
                        }
                        Util.send(invoker, error);
                        continue;
                    }
                    boolean success = this.writeFile(key, newcfg, invoker);
                    byte[] verify = this.readFile(key, invoker);
                    String verify_hash = this.getHash(verify, invoker);
                    if (verify == null || !success || !verify_hash.equals(check_hash)) {
                        String error = "&4BLAD KRYTYCZNY ZAPISU DO PLIKU! s: " + success + " v: " + (verify == null) + " c: " + verify_hash.equals(check_hash) + " f: " + key + " cfg: " + ServerName.getConfigType() + " srv: " + ServerName.getServerName();
                        if (invoker == null) {
                            Util.acnotify(error);
                            continue;
                        }
                        Util.send(invoker, error);
                        continue;
                    }
                    if (invoker == null) {
                        Util.acnotify("Zaktualizowano " + key + " server: " + ServerName.getServerName());
                    } else {
                        Util.send(invoker, "Zaktualizowano " + key + " server: " + ServerName.getServerName());
                    }
                }
                this.loadFiles(invoker);
            }
        }
        catch (Exception e) {
            if (invoker == null) {
                Util.acnotify("&4Updater: unknown error. Server: " + ServerName.getServerName());
                Util.acnotify(e.getMessage());
            } else {
                Util.send(invoker, "&4Updater: unknown. Server: " + ServerName.getServerName());
                Util.send(invoker, e.getMessage());
            }
            return;
        }
    }

    private byte[] readFile(String path, CommandSender invoker) {
        File readFrom = new File(path);
        if (!readFrom.exists()) {
            String error = "&4Plik " + path + " nie istnieje! Zglos to koniecznie do Lorak_/HesterQ. Server: " + ServerName.getServerName();
            if (invoker == null) {
                Util.acnotify(error);
            } else {
                Util.send(invoker, error);
            }
            return null;
        }
        try {
            return Files.readAllBytes(readFrom.toPath());
        }
        catch (IOException e) {
            String error = "&4Blad podczas wczytywania " + path + "! Zglos to koniecznie do Lorak_/HesterQ. Server: " + ServerName.getServerName() + " Error: " + e.getMessage();
            if (invoker == null) {
                Util.acnotify(error);
            } else {
                Util.send(invoker, error);
            }
            return null;
        }
    }

    private String getHash(byte[] message, CommandSender invoker) {
        StringBuilder hash = new StringBuilder();
        try {
            byte[] byteHash;
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(message);
            for (byte b : byteHash = md.digest()) {
                hash.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (Exception e) {
            String error = "&4Blad sumy kontrolnej. Server: " + ServerName.getServerName() + ". LENGTH: " + message.length + " Error: " + e.getMessage();
            if (invoker == null) {
                Util.acnotify(error);
            } else {
                Util.send(invoker, error);
            }
            return null;
        }
        return hash.toString();
    }

    private byte[] downloadURL(String url, CommandSender invoker) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int bytesRead;
            URL download = new URL(url);
            URLConnection connection = download.openConnection();
            InputStream in = connection.getInputStream();
            while ((bytesRead = in.read(buffer)) > 0) {
                out.write(buffer, 0, bytesRead);
            }
            in.close();
        }
        catch (Exception e) {
            String error = "&4Blad podczas  pobierania danych " + e.getMessage() + " Server: " + ServerName.getServerName();
            if (invoker == null) {
                Util.acnotify(error);
            } else {
                Util.send(invoker, error);
            }
            return null;
        }
        return out.toByteArray();
    }

    private boolean writeFile(String path, byte[] data, CommandSender invoker) {
        File f = new File(path);
        if (!f.exists()) {
            String error = "&4Plik " + path + " nie istnieje! Server: " + ServerName.getServerName();
            return false;
        }
        try {
            FileOutputStream writer = new FileOutputStream(f);
            writer.write(data, 0, data.length);
            writer.flush();
            writer.close();
            return true;
        }
        catch (FileNotFoundException e) {
            String error = "&4Plik " + path + " nie istnieje! Server: " + ServerName.getServerName() + " Error: " + e.getMessage();
            if (invoker == null) {
                Util.acnotify(error);
            } else {
                Util.send(invoker, error);
            }
            return false;
        }
        catch (IOException e) {
            String error = "&4Blad podczas zapisu pliku " + path + " Server: " + ServerName.getServerName() + " Error: " + e.getMessage();
            if (invoker == null) {
                Util.acnotify(error);
            } else {
                Util.send(invoker, error);
            }
            return false;
        }
    }
}

